#include <lvsmon.h>
#include <banner.h>
#include <util.h>
#include <ctype.h>
#include <string.h>

/* 
* Name        : Banner Plugin (banner)
* License     : GPL
* Author      : Gianni Tedesco <gianni@ecsc.co.uk>
* Description : Checks the banner of any service
* Arguments   : Substring to check for in the banner,
*               leave it blank to accept any banner.
*/

static const char rcsid[]=
	"@(#) $Id: banner.c,v 1.2 2002/01/24 12:38:47 gianni Exp $";

plugin_t banner_plugin={
	NULL, "banner",
	NULL, banner_check,
	banner_validate, 15
};

int banner_validate(char *conf, void **priv)
{
	p_banner_priv p;

	if ( !(p=malloc(sizeof(banner_priv_t))) ) return 0;
	if ( !(p->banner=strdup(conf)) ) {
		free(p);
		return 0;
	}

	p->len=strlen(p->banner);
	*priv=p;
	return 1;
}

int banner_check(char *buf, int len, void *priv)
{
	p_banner_priv p=(p_banner_priv)priv;
	u_int32_t i;
	char *str;

	/* Don't check */
	if ( !p->len ) return 1;

	/* If substring cant't fit, then its an obvious fail */
	if ( len < p->len ) return 0;

	/* memcmp() is safe with binary data */
	for(str=buf, i=0; i<len-p->len; i++, str++){
		if ( memcmp(p->banner, str, p->len)==0 ) return 1;
	}

	return 0;
}
