#include <lvsmon.h>
#include <http.h>
#include <util.h>
#include <ctype.h>
#include <string.h>

/*
* Name        : HTTP Plugin (http)
* License     : GPL
* Author      : Gianni Tedesco <gianni@ecsc.co.uk>
* Description : Sends an http query to a webserver and checks
* 	        the status code sent back.
* Arguments   : The host to put in the header
*/

static const char rcsid[]=
	"@(#) $Id: http.c,v 1.6 2002/01/24 12:48:54 gianni Exp $";

plugin_t http_plugin={
	NULL, "http",
	http_sendq, http_check,
	http_validate, 15
};

int http_validate(char *conf, void **priv)
{
	*priv = (conf) ? strdup(conf) : NULL ;
	
	/* This really just checks that the strdup() succeeded */
	return ( conf && *priv==NULL ) ? 0 : 1;
}

int http_sendq(int sock, void *priv)
{
	return socket_out(sock,
		"HEAD / HTTP/1.1\n"
		"Host: %s\n"
		"User-Agent: LVSmon ($Revision: 1.6 $)\n"
		"X-LVSMon: true\n"
		"\n",
		priv ? priv : "127.0.0.1" );
}

/* Check RFC 1945 conformance
* "HTTP [0-9]\.[0-9] [0-9]{3} \r\n"
* */
int http_check(char *buf, int len, void *priv)
{
	if ( (len >= 13) && buf[9]=='2' )
		return 1;
	else
		return 0;
}
