#include <lvsmon.h>
#include <status.h>
#include <util.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>

static const char rcsid[]=
	"@(#) $Id: status.c,v 1.2 2002/01/24 12:38:47 gianni Exp $";

char tb[512];
struct tm *rtime;
struct in_addr a;
char *errstr[]={
	"async_tcpsocket()",
	"connect1()",
	"getsockopt()",
	"connect()",
	"Connect",
	"send()",
	"recv()",
	"Recieve",
};

const char *status_err(p_mon m)
{
	static char buf[512];
	static char *p=(char *)&buf;

	buf[0]='\0';

	if ( m->err < sizeof(errstr)/sizeof(char *)) {
		switch (m->err) {
			case ERR_SOCKET:
			case ERR_CONNECT:
			case ERR_GETSOCKOPT:
			case ERR_CONNECT2:
			case ERR_SEND:
			case ERR_RECV:
				snprintf(p, 512, "%s: %s",
					errstr[m->err],
					get_nerr(m->errnum));
				return p;
			case ERR_CONNTIMEOUT:
			case ERR_RECVTIMEOUT:
				snprintf(p, 512, "%s timed out (%i seconds)",
					errstr[m->err],
					m->errnum);
				return p;
			case ERR_CUSTOM:
				/* TODO: Ask plugin about errnum */
				snprintf(p, 512, "CUSTOM(%s/%u)",
					m->plugin->name,
					m->errnum);
				return p;
		}
	}

	snprintf(p, 512, "UNKNOWN_ERROR(%u/%u)", m->err, m->errnum);
	return p;
}


void status_up(p_mon m)
{
	a.s_addr=m->addr;

	/* Report the actual time that success was reported */
	rtime=localtime(&m->lastsuccess);
	strftime((char *)&tb, sizeof(tb)-1, "%d-%m-%Y %H:%M:%S", rtime);
	
	printf("%s: STATUS=\033[1;32mUP\033[0;39m ADDR=%s PORT=%i\n", tb,
		inet_ntoa(a), m->port);
}

void status_down(p_mon m)
{
	a.s_addr=m->addr;
	
	/* Report the time the attempted connection begun */
	rtime=localtime(&m->lastconn);
	strftime((char *)&tb, sizeof(tb)-1, "%d-%m-%Y %H:%M:%S", rtime);
	
	printf("%s: STATUS=\033[1;31mDOWN\033[0;39m ADDR=%s PORT=%i -- %s\n", tb,
		inet_ntoa(a), m->port, status_err(m));
}
