#include <lvsmon.h>
#include <util.h>
#include <errno.h>
#include <unistd.h>
#include <sys/socket.h>

#include <string.h>

static const char rcsid[]=
	"@(#) $Id: util.c,v 1.4 2002/01/24 12:38:47 gianni Exp $";

/* Utility function for plugins */
int socket_out(int s, const char *format, ...)
{
	static char output[BUFFER_SIZE];
	va_list va;
	int len;

	va_start(va, format);
	len=vsnprintf(output, BUFFER_SIZE, format, va);
	va_end(va);

	return send(s, output, len, 0);
}

/* Get an error string from errno */
const char *get_err(void)
{
	return get_nerr(errno);
}

const char *get_nerr(int num)
{
	/* Ugh. Somehow I don't trust
	* glibc to get this right. */
	if (num>=sys_nerr) {
		return "errno>=sys_nerr";
	}
	return sys_errlist[num];
}


void die_err(void)
{
	/* Sleep 500ms before exiting
	* this stops scripts looping 
	* for ever in case of error */
	usleep(500000);
	exit(STATUS_ERR);
}
