#ifndef __LVSMON_HEADER_INCLUDED__
#define __LVSMON_HEADER_INCLUDED__
/* @(#) $Id: lvsmon.h,v 1.14 2002/05/15 08:16:51 gianni Exp $ */

#define VERSION_STRING		"LVSmon v0.0.2\n" COPYRIGHT_STRING
#define COPYRIGHT_STRING	"Copyright (c) 2002 Gianni Tedesco\n" GNU_STRING
#define GNU_STRING		"Released under the terms of the GNU GPL Version 2\n"

/* ANSI C Headers */
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>

#include <time.h>
#include <sys/types.h>
#include <netinet/in.h>

#define BUFFER_SIZE	4096

/******************************************
 * Exit codes
 *******************************************/
#define STATUS_OK	0
#define STATUS_ERR	1
#define STATUS_DBG	2

enum {
	ERR_SOCKET,
	ERR_CONNECT,
	ERR_GETSOCKOPT,
	ERR_CONNECT2,
	ERR_CONNTIMEOUT,
	ERR_SEND,
	ERR_RECV,
	ERR_RECVTIMEOUT,
	ERR_CUSTOM,
	ERR_SUCCESS
}errcodes;

/* Plugin stuff */
typedef int (*proc_sendq)(int , void *);
typedef int (*proc_check)(char *, int, void *, int *);
typedef int (*proc_validate)(char *, void **);
typedef int (*proc_errno)(char *, int, int);
typedef struct plugin {
	struct plugin	*next;
	char		*name;
	proc_sendq	send_query;
	proc_check	check_results;
	proc_validate	validate;
	proc_errno	errnum;
	int		bufflen;
}plugin_t, *p_plugin;

/* Each monitor process */
typedef struct mon {
	struct mon	*next;

	/* Control data */
	int		phase;
	int		s;
	int		pindex;
	time_t		interval;

	/* Last time a connection was attempted */
	time_t		lastconn;

	/* last successful connection */
	time_t		lastsuccess;

	/* Number of failures since then */
	unsigned int	fails;

	/* Error number and error value,
	* errno can be a real errno or
	* a plugin errno */
	unsigned char	err;
	int		errnum;

	/* Current state (UP/DOWN) */
	int		state;

	/* Plugin stuff */	
	p_plugin	plugin;
	void		*priv;
	
	/* Network info */
	in_port_t	port;
	in_addr_t	addr;
}mon_t, *p_mon;

/* Global variables */
typedef struct _globals {
	/* User configurable stuff */
	time_t		interval;
	time_t		timeout;
	char		*config;

	/* Plugin list */
	p_plugin	plugins;

	/* Shared recv buffer */
	int 		buflen;
	char		*buf;

	time_t		now;
}globals_t, *p_globals;
extern globals_t	globals;

extern p_mon 		monitors;
extern p_mon	 	last_mon;
extern int 		num_monitors;

#endif /* __LVSMON_HEADER_INCLUDED__ */
