#ifndef __UTIL_HEADER_INCLUDED__
#define __UTIL_HEADER_INCLUDED__

/* @(#) $Id: util.h,v 1.6 2002/04/15 08:30:09 gianni Exp $ */

#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <unistd.h>

/* Our only real function */
int socket_out(int, const char *, ...);

extern char *cmd;

static inline const char *get_nerr(int num){
	return (num>=sys_nerr) ? "[unknown error]" : sys_errlist[num];
}

static inline const char *get_err(void){return get_nerr(errno);}
static inline void die_ok(void) {usleep(500000); exit(STATUS_OK) ;}
static inline void die_err(void) {usleep(500000); exit(STATUS_ERR);}

#define strerr(x, arg...) fprintf(stderr, "%s: " x, cmd, ## arg)
#define die_strerr(x, arg...) do {strerr(x, ## arg); die_err();}while(0)

#endif /* __UTIL_HEADER_INCLUDED__ */
