#include <sys/types.h>
#include <sys/socket.h>
#include <asyncio.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <unistd.h>
#include <errno.h>

/* Create a TCP socket for async I/O */
int async_tcpsocket(void)
{
	int s, f, e;
	
	/* Open a socket */
	if ( (s=socket(AF_INET, SOCK_STREAM, 0)) < 0 ) {
		return -1;
	}

	/* Get current flags */
	if ( (f=fcntl(s, F_GETFL, 0)) < 0 ) {
		e=errno;
		close(s);
		errno=e;
		return -1;
	}
	
	/* Set it non-blocking */
	if ( (fcntl(s, F_SETFL, f | O_NONBLOCK)) < 0 ) {
		e=errno;
		close(s);
		errno=e;
		return -1;
	}
	
	return s;
}
