#include <lvsmon.h>
#include <conf.h>
#include <util.h>

#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <netdb.h>
#include <errno.h>

static const char rcsid[]=
	"@(#) $Id: config.c,v 1.12 2002/05/15 08:45:55 gianni Exp $";

#define MAXLEN 1024

void config_add_mon(p_mon m)
{
	/* validate the security critical fields */
	m->s=-1;
	m->next=NULL;

	if ( monitors && last_mon ) {
		last_mon->next=m;
		last_mon=m;
	}else{
		monitors=m;
		last_mon=m;
	}

	num_monitors++;
}

p_plugin find_plugin(char *name)
{
	p_plugin p;

	for(p=globals.plugins; p; p=p->next) {
		if ( strcmp(name, p->name) == 0 ) return p;
	}
	return NULL;
}

int config_resolve(char *ip, in_addr_t *in)
{
	struct hostent *h;
	struct in_addr a;

	if ( inet_aton(ip, &a) ) {
		*in=a.s_addr;
		return 1;
	}

	if ( (h=gethostbyname(ip)) ) {
		memcpy(&a, h->h_addr, h->h_length);
		*in=a.s_addr;
		return 1;
	}
				
	return 0;
}

/* Parse an individual line */
void config_line(char *buf, char *fn, unsigned int line)
{
	int state=0;
	char *cur;
	char *toks[4];
	int i=0;
	struct mon *m;
	unsigned long int pval;

	/* Simple state machine parser */
	for(cur=buf; ; cur++) {
		if ( *cur=='\n' || *cur=='\n' || *cur=='\r' )  {
			*cur=0;
			break;
		}

		if ( state==0 ) {
			toks[i++]=cur;
			state=1;
			if ( i==4 ) state=2;
		}else if ( state==1 ) {
			if ( *cur==':' ) {
				*cur=0;
				state=0;
			}
		}
	}

	/* Check we got the right tokens */
	if ( i!=4 && i!=3 ) {
		die_strerr("%s:%u: Parse error\n", fn, line);
	}

	/* Private data is optional */
	if ( i==3 ) toks[3]=NULL;

	/* Allocate the shit */
	if ( !(m=malloc(sizeof(*m))) ) {
		die_strerr("%s:%u: %s\n", fn, line, get_err());
	}

	/* Find the right plugin */
	if ( !(m->plugin=find_plugin(toks[0])) ) {
		die_strerr("%s:%u: Unable to find '%s' plugin\n",
			fn, line, toks[0]);
	}
	
	/* Convert the port value */
	if ( (pval=strtoul(toks[2], NULL, 10))==ULONG_MAX &&
		errno==ERANGE ) {
		goto prange;
	}
	if ( (m->port=(in_port_t)pval) > 65535 ) {
		goto prange;
	}
	
	/* Validate with the plugin */
	if ( !m->plugin->validate(toks[3], &m->priv) ) {
		die_strerr("%s:%u: Unable to validate user "
			"data for '%s' plugin\n",
			fn, line, toks[0]);
	}
	
	/* Resolve the address */
	if ( !config_resolve(toks[1], &m->addr) ) {
		die_strerr("%s:%u: Unable to resolve address: %s\n",
			fn, line, toks[1]);
	}

	/* Non-configured fields */
	m->interval=globals.interval;
	config_add_mon(m);
	return;

prange:
	die_strerr("line %u: Port is out of range: %s\n",
		line, toks[2]);
}

int config_parse(void)
{
	char buf[MAXLEN];
	int line=0;
	FILE *f;
	char *fn;

	if ( globals.config ) {
		fn=globals.config;
		if ( !(f=fopen(globals.config, "r")) ) {
			die_strerr("%s: open(): %s\n",
				globals.config,
				get_err());
		}
	}else{
		f=stdin;
		fn="stdin";
	}
	
	while(fgets(buf, sizeof(buf), f)) {
		line++;	
		
		/* Why must libc be so crappy? */
		if ( !strchr(buf, '\n') )
			die_strerr("%s:%u: line greater than MAXLEN (%u)\n",
				fn, line, sizeof(buf));

		if ( buf[0]!='#' && buf[0]!='\r' && buf[0]!='\n') {
			config_line(buf, fn, line);
		}
	}

	fclose(f);
	return 1;
}
