#include <lvsmon.h>
#include <http.h>
#include <util.h>
#include <ctype.h>
#include <string.h>

/*
* Name        : HTTP Plugin (http)
* License     : GPL
* Author      : Gianni Tedesco <gianni@ecsc.co.uk>
* Description : Sends an http query to a webserver and checks
* 	        the status code sent back.
* Arguments   : The host to put in the header
*/

static const char rcsid[]=
	"@(#) $Id: http.c,v 1.9 2002/04/15 08:30:09 gianni Exp $";

plugin_t http_plugin={
	NULL,
	"http",
	http_sendq,
	http_check,
	http_validate,
	http_errno,
	15
};

int http_errno(char *buf, int buflen, int err)
{
	if ( err < 0 ) {
		return snprintf(buf, buflen, "Malformed HTTP response");
	}else{
		return snprintf(buf, buflen, "HTTP error code %i", err);
	}
}

int http_validate(char *conf, void **priv)
{
	return (conf && (*priv=strdup(conf))!=NULL);
}

int http_sendq(int sock, void *priv)
{
	return socket_out(sock,
		"HEAD http://%s/ HTTP/1.1\n"
		"Host: %s\n"
		"User-Agent: LVSmon ($Revision: 1.9 $)\n"
		"X-LVSMon: true\n"
		"\n", priv, priv);
}

/* Check RFC 1945 conformance
* "HTTP [0-9]\.[0-9] [0-9]{3} \r\n"
* */
int http_check(char *buf, int len, void *priv, int *errnum)
{
	if ( len < 13 ) {
		*errnum=-1;
		return 0;
	}
	
	if ( buf[9]=='2' ) {
		/* 2?? indicates success code in HTTP */
		return 1;
	}else{
		/* Make an integer of the response
		* code and use that for an errnum */
		int b[3];

		b[0]=buf[9]-'0';
		b[1]=buf[10]-'0';
		b[2]=buf[11]-'0';
		*errnum=-1;

		if ( b[0] > 9 || b[0] < 0 ) return 0;
		if ( b[1] > 9 || b[1] < 0 ) return 0;
		if ( b[2] > 9 || b[2] < 0 ) return 0;
		
		*errnum=b[0]*100 + b[1]*10 + b[2];
		return 0;
	}
}
