#include <lvsmon.h>
#include <util.h>

#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>

#include <status.h>

static const char rcsid[]=
	"@(#) $Id: status.c,v 1.10 2002/05/15 08:18:45 gianni Exp $";

char tb[32];
struct tm *rtime;
struct in_addr a;

int out_fd;
char *errstr[]={
	"async_tcpsocket()",
	"connect1()",
	"getsockopt()",
	"connect()",
	"Connect",
	"send()",
	"recv()",
	"Recieve",
	"Custom",
};

void status_init(void)
{
}

const char *status_err(p_mon m)
{
	static char p[512];

	p[0]='\0';

	if ( m->err < sizeof(errstr)/sizeof(char *)) {
		switch (m->err) {
			case ERR_SOCKET:
			case ERR_CONNECT:
			case ERR_GETSOCKOPT:
			case ERR_CONNECT2:
			case ERR_SEND:
			case ERR_RECV:
				snprintf(p, 512, "%s: %s",
					errstr[m->err],
					get_nerr(m->errnum));
				return p;
			case ERR_CONNTIMEOUT:
			case ERR_RECVTIMEOUT:
				snprintf(p, 512, "%s timed out (%i seconds)",
					errstr[m->err],
					m->errnum);
				return p;
			case ERR_CUSTOM:
				if ( !(m->plugin->errnum && m->plugin->errnum(p, 512, m->errnum)) ) {
					snprintf(p, 512, "CUSTOM(%s/%u)",
						m->plugin->name,
						m->errnum);
				}
				return p;
		}
	}

	snprintf(p, 512, "UNKNOWN_ERROR(%u/%u)", m->err, m->errnum);
	return p;
}


void status_up(p_mon m)
{
	a.s_addr=m->addr;

	/* Report the actual time that success was reported */
	rtime=localtime(&m->lastsuccess);
	strftime((char *)&tb, sizeof(tb)-1, "%Y-%m-%d %H:%M:%S", rtime);
	
	printf("%s: STATUS=UP ADDR=%s PORT=%i\n", tb,
		inet_ntoa(a), m->port);
	fflush(stdout);
}

void status_down(p_mon m)
{
	a.s_addr=m->addr;
	
	/* Report the time the attempted connection begun */
	rtime=localtime(&m->lastconn);
	strftime((char *)&tb, sizeof(tb)-1, "%Y-%m-%d %H:%M:%S", rtime);
	
	printf("%s: STATUS=DOWN ADDR=%s PORT=%i -- %s\n", tb,
		inet_ntoa(a), m->port, status_err(m));
	fflush(stdout);
}
